***MODIFY THE FOLLOWING LINES AS APPROPRIATE FOR YOUR LOCAL ENVIRONMENT.;

**hqx file has the responses to the screener                                         
//HQX   DD  DSN=NNF1ITL.OPEN.HEALTHQX.XPT,DISP=SHR   

**demo file has information such as age and gender of respondent                           
//DEMO  DD  DSN=NNF1ITL.OPEN.DEMO.ORIG.XPT,DISP=SHR 

                            
***MODIFY THE PRECEDING LINES AS APPROPRIATE FOR YOUR LOCAL ENVIRONMENT.;

                                
                                                                                
PROC CIMPORT DATA=HQX FILE=HQX;                                                 
                                                                                
PROC SORT DATA=HQX;                                                             
  BY ID;                                                                        
                                                                                
PROC CIMPORT DATA=DEMO FILE=DEMO;                                               
                                             
PROC SORT DATA=DEMO;                                                            
  BY ID;                                                                        
                                                                                
DATA HQX;                                                                       
  MERGE HQX (IN =H) DEMO (IN=D);                                                
  BY ID;                                                                        
  IF H AND D;                                                                   
                                                                                                                            
                                                                                
DATA HQX;                                                                       
  SET HQX;                                                                      
                                                                                
                                                                                
  %MACRO FREQN (INC,OUTN);                                                      
   IF &INC='1' THEN &OUTN=0;                                                    
    ELSE IF &INC='2' THEN &OUTN=.067;                                           
    ELSE IF &INC='3' THEN &OUTN=.214;                                           
    ELSE IF &INC='4' THEN &OUTN=.5;                                             
    ELSE IF &INC='5' THEN &OUTN=.786;                                           
    ELSE IF &INC='6' THEN &OUTN=1;                                              
    ELSE IF &INC='7' THEN &OUTN=2;                                              
    ELSE IF &INC='8' THEN &OUTN=3;                                              
    ELSE IF &INC='9' THEN &OUTN=4.5;                                            
  %MEND FREQN;                                                                  
                                                                                
                                                                                
 %FREQN(HQ1,COLDCER);                                                           
 %FREQN(HQ2,MILK);                                                              
 %FREQN(HQ3,BACON);                                                             
 %FREQN(HQ4,HOTDOG);                                                            
 %FREQN(HQ5,WHGRBRD);                                                           
 %FREQN(HQ6,FRTJ);                                                              
 %FREQN(HQ7,FRUIT);                                                             
 %FREQN(HQ8,MAYO);                                                              
 %FREQN(HQ9,SALAD);                                                             
 %FREQN(HQ10,FRFRY);                                                            
 %FREQN(HQ11,OTHPOT);                                                           
 %FREQN(HQ12,DRBEAN);                                                           
 %FREQN(HQ13,OTHVEG);                                                           
 %FREQN(HQ14,PASTA);                                                            
 %FREQN(HQ15,NUTSEED);                                                          
 %FREQN(HQ16,CHIPS);                                                            
                                                                                
  WHMILK=0; TWOPMILK=0; ONEPMILK=0; SKIMMILK=0;                                 
  IF HQ2A=1 THEN WHMILK=MILK;                                                   
   ELSE IF HQ2A=2 THEN TWOPMILK=MILK;                                           
   ELSE IF HQ2A=3 THEN ONEPMILK=MILK;                                           
   ELSE IF HQ2A=4 THEN SKIMMILK=MILK;                                           
   ELSE IF HQ2A=5 THEN SKIMMILK=MILK;                                           
                                                                                
                                                                                
*adjust fruit/veg frequency of food intake by gender/age specific factors;      
* this generates results for 1/2 cup pyramid serving units (predfv7 predfv6);                                                                                
                                                                                
if (gender=1 and 18 <= age < 28) then do;                                       
    FRUITM=1.3010000*FRUIT;                                                     
    OTHVEGM=0.7500000*OTHVEG;                                                   
    FRTJM=2.0000000*FRTJ;                                                       
    OTHPOTM=2.0000000*OTHPOT;                                                   
    SALADM=0.5450000*SALAD;                                                     
    DRBEANM=1.3740000*DRBEAN;                                                   
    FRFRYM=2.0000000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and 28 <= age < 38) then do;                                  
    FRUITM=1.3010000*FRUIT;                                                     
    OTHVEGM=0.9060000*OTHVEG;                                                   
    FRTJM=1.6675000*FRTJ;                                                       
    OTHPOTM=2.0000000*OTHPOT;                                                   
    SALADM=0.7080000*SALAD;                                                     
    DRBEANM=1.0470000*DRBEAN;                                                   
    FRFRYM=2.0000000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and 38 <= age < 48) then do;                                  
    FRUITM=1.2295714*FRUIT;                                                     
    OTHVEGM=0.9745000*OTHVEG;                                                   
    FRTJM=1.3350000*FRTJ;                                                       
    OTHPOTM=1.9990000*OTHPOT;                                                   
    SALADM=0.7545000*SALAD;                                                     
    DRBEANM=1.0650000*DRBEAN;                                                   
    FRFRYM=1.7730000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and 48 <= age < 58) then do;                                  
    FRUITM=1.2273333*FRUIT;                                                     
    OTHVEGM=1.0000000*OTHVEG;                                                   
    FRTJM=1.3350000*FRTJ;                                                       
    OTHPOTM=1.9990000*OTHPOT;                                                   
    SALADM=0.7500000*SALAD;                                                     
    DRBEANM=1.2270000*DRBEAN;                                                   
    FRFRYM=1.7100000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and 58 <= age < 68) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=1.0000000*OTHVEG;                                                   
    FRTJM=1.3340000*FRTJ;                                                       
    OTHPOTM=1.9140000*OTHPOT;                                                   
    SALADM=0.8335000*SALAD;                                                     
    DRBEANM=1.0000000*DRBEAN;                                                   
    FRFRYM=1.4000000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and 68 <= age < 78) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=0.8800000*OTHVEG;                                                   
    FRTJM=1.0010000*FRTJ;                                                       
    OTHPOTM=1.5440000*OTHPOT;                                                   
    SALADM=0.7500000*SALAD;                                                     
    DRBEANM=1.0000000 *DRBEAN;                                                  
    FRFRYM=1.2500000*FRFRY;                                                     
  end;                                                                          
else if (gender=1 and age >= 78) then do;                                       
    FRUITM=1.0523333*FRUIT;                                                     
    OTHVEGM=0.8333333*OTHVEG;                                                   
    FRTJM=1.0010000*FRTJ;                                                       
    OTHPOTM=1.5080000*OTHPOT;                                                   
    SALADM=0.8225000*SALAD;                                                     
    DRBEANM=1.1140000*DRBEAN;                                                   
    FRFRYM=1.2500000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 18 <= age < 28) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=0.7022000*OTHVEG;                                                   
    FRTJM=1.5005000*FRTJ;                                                       
    OTHPOTM=1.5440000*OTHPOT;                                                   
    SALADM=0.6135000*SALAD;                                                     
    DRBEANM=0.9640000*DRBEAN;                                                   
    FRFRYM=1.4810000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 28 <= age < 38) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=0.7793333*OTHVEG;                                                   
    FRTJM=1.3340000*FRTJ;                                                       
    OTHPOTM=1.5440000*OTHPOT;                                                   
    SALADM=0.5725000*SALAD;                                                     
    DRBEANM=0.6840000*DRBEAN;                                                   
    FRFRYM=1.3655000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 38 <= age < 48) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=0.7925000*OTHVEG;                                                   
    FRTJM=1.3340000*FRTJ;                                                       
    OTHPOTM=1.5280000*OTHPOT;                                                   
    SALADM=0.8333333*SALAD;                                                     
    DRBEANM=0.8000000*DRBEAN;                                                   
    FRFRYM=1.2720000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 48 <= age < 58) then do;                                  
    FRUITM=1.1680000*FRUIT;                                                     
    OTHVEGM=0.7885000*OTHVEG;                                                   
    FRTJM=1.2512500*FRTJ;                                                       
    OTHPOTM=1.5440000*OTHPOT;                                                   
    SALADM=1.0000000*SALAD;                                                     
    DRBEANM=0.6870000*DRBEAN;                                                   
    FRFRYM=1.4000000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 58 <= age < 68) then do;                                  
    FRUITM=1.1505000*FRUIT;                                                     
    OTHVEGM=0.7740000*OTHVEG;                                                   
    FRTJM=1.0195000*FRTJ;                                                       
    OTHPOTM=1.4990000*OTHPOT;                                                   
    SALADM=0.7955000*SALAD;                                                     
    DRBEANM=0.8220000*DRBEAN;                                                   
    FRFRYM=1.0000000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and 68 <= age < 78) then do;                                  
    FRUITM=1.0838333*FRUIT;                                                     
    OTHVEGM=0.8330000*OTHVEG;                                                   
    FRTJM=1.0005000*FRTJ;                                                       
    OTHPOTM=1.5160000*OTHPOT;                                                   
    SALADM=0.6250000*SALAD;                                                     
    DRBEANM=0.8070000*DRBEAN;                                                   
    FRFRYM=1.0260000*FRFRY;                                                     
  end;                                                                          
else if (gender=2 and age >= 78) then do;                                       
    FRUITM=1.0000000*FRUIT;                                                     
    OTHVEGM=0.8567500*OTHVEG;                                                   
    FRTJM=1.0005000*FRTJ;                                                       
    OTHPOTM=1.2720000*OTHPOT;                                                   
    SALADM=0.7500000*SALAD;                                                     
    DRBEANM=1.0000000*DRBEAN;                                                   
    FRFRYM=1.0000000*FRFRY;                                                     
  end;                                                                          
                                                                                
                                                                                
  FV7=FRUITM+OTHVEGM+FRTJM+OTHPOTM+SALADM+DRBEANM+FRFRYM;                       
  FV6=FRUITM+OTHVEGM+FRTJM+OTHPOTM+SALADM+DRBEANM;                              
  SQFV7=SQRT(FV7);                                                              
  SQFV6=SQRT(FV6);                                                              
                                                                                
                                                                                
*adjust food frequency by gender/age specific factors;                          
                                                                                
if (gender=1 and 18 <= age < 28) then do;                                       
    FRUITA=131.750000*FRUIT;                                                    
    OTHVEGA=60.0133333*OTHVEG;                                                  
    FRTJA=372.000000*FRTJ;                                                      
    OTHPOTA=210.000000*OTHPOT;                                                  
    SALADA=29.0000000*SALAD;                                                    
    DRBEANA=180.000000*DRBEAN;                                                  
    FRFRYA=112.500000*FRFRY;                                                    
    COLDCERA=74.6666667*COLDCER;                                                
    WHMILKA=305.000000*WHMILK;                                                  
    TWOPMILKA=259.250000*TWOPMILK;                                              
    ONEPMILKA=341.600000*ONEPMILK;                                              
    SKIMMILKA=366.666667*SKIMMILK;                                              
    BACONA=25.0000000*BACON;                                                    
    HOTDOGA=114.000000*HOTDOG;                                                  
    WGBRDA=56.0000000*WHGRBRD;                                                  
    REGDRSNGA=23.5433333*MAYO;                                                  
    PASTAA=330.000000*PASTA;                                                    
    NUTSA=31.6250000*NUTSEED;                                                   
    REGCHIPSA=40.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and 28 <= age < 38) then do;                                  
    FRUITA=128.000000*FRUIT;                                                    
    OTHVEGA=73.0000000*OTHVEG;                                                  
    FRTJA=311.250000*FRTJ;                                                      
    OTHPOTA=196.000000*OTHPOT;                                                  
    SALADA=36.6666667*SALAD;                                                    
    DRBEANA=130.000000*DRBEAN;                                                  
    FRFRYA=114.000000*FRFRY;                                                    
    COLDCERA=61.5000000*COLDCER;                                                
    WHMILKA=259.250000*WHMILK;                                                  
    TWOPMILKA=305.000000*TWOPMILK;                                              
    ONEPMILKA=245.000000*ONEPMILK;                                              
    SKIMMILKA=250.000000*SKIMMILK;                                              
    BACONA=40.2500000*BACON;                                                    
    HOTDOGA=85.5000000*HOTDOG;                                                  
    WGBRDA=54.0000000*WHGRBRD;                                                  
    REGDRSNGA=23.6266667*MAYO;                                                  
    PASTAA=280.000000*PASTA;                                                    
    NUTSA=58.0000000*NUTSEED;                                                   
    REGCHIPSA=40.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and 38 <= age < 48) then do;                                  
    FRUITA=123.200000*FRUIT;                                                    
    OTHVEGA=74.0633333*OTHVEG;                                                  
    FRTJA=249.000000 *FRTJ;                                                     
    OTHPOTA=184.000000*OTHPOT;                                                  
    SALADA=41.2500000*SALAD;                                                    
    DRBEANA=172.000000*DRBEAN;                                                  
    FRFRYA=100.000000*FRFRY;                                                    
    COLDCERA=57.5000000*COLDCER;                                                
    WHMILKA=306.710000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=245.000000*ONEPMILK;                                              
    SKIMMILKA=250.000000*SKIMMILK;                                              
    BACONA=32.0000000*BACON;                                                    
    HOTDOGA=88.0000000*HOTDOG;                                                  
    WGBRDA=52.0000000*WHGRBRD;                                                  
    REGDRSNGA=22.0300000*MAYO;                                                  
    PASTAA=280.000000*PASTA;                                                    
    NUTSA=35.5000000*NUTSEED;                                                   
    REGCHIPSA=31.8950000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and 48 <= age < 58) then do;                                  
    FRUITA=127.500000*FRUIT;                                                    
    OTHVEGA=79.8333333*OTHVEG;                                                  
    FRTJA=249.000000 *FRTJ;                                                     
    OTHPOTA=161.000000*OTHPOT;                                                  
    SALADA=35.0000000*SALAD;                                                    
    DRBEANA=172.000000*DRBEAN;                                                  
    FRFRYA=100.000000*FRFRY;                                                    
    COLDCERA=56.0000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=244.000000*ONEPMILK;                                              
    SKIMMILKA=245.000000*SKIMMILK;                                              
    BACONA=32.0000000*BACON;                                                    
    HOTDOGA=114.000000*HOTDOG;                                                  
    WGBRDA=52.0000000*WHGRBRD;                                                  
    REGDRSNGA=27.5000000*MAYO;                                                  
    PASTAA=247.500000*PASTA;                                                    
    NUTSA=54.6650000*NUTSEED;                                                   
    REGCHIPSA=30.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and 58 <= age < 68) then do;                                  
    FRUITA=122.000000*FRUIT;                                                    
    OTHVEGA=76.5000000*OTHVEG;                                                  
    FRTJA=248.000000*FRTJ;                                                      
    OTHPOTA=145.000000*OTHPOT;                                                  
    SALADA=42.0000000*SALAD;                                                    
    DRBEANA=158.125000*DRBEAN;                                                  
    FRFRYA=85.5000000*FRFRY;                                                    
    COLDCERA=46.0000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=213.500000*ONEPMILK;                                              
    SKIMMILKA=214.375000*SKIMMILK;                                              
    BACONA=27.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=51.0000000*WHGRBRD;                                                  
    REGDRSNGA=24.5850000*MAYO;                                                  
    PASTAA=280.000000*PASTA;                                                    
    NUTSA=39.2500000*NUTSEED;                                                   
    REGCHIPSA=26.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and 68 <= age < 78) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=73.0000000*OTHVEG;                                                  
    FRTJA=186.750000*FRTJ;                                                      
    OTHPOTA=127.000000*OTHPOT;                                                  
    SALADA=41.2500000*SALAD;                                                    
    DRBEANA=175.000000*DRBEAN;                                                  
    FRFRYA=85.5000000*FRFRY;                                                    
    COLDCERA=39.0000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=183.000000*TWOPMILK;                                              
    ONEPMILKA=223.666667*ONEPMILK;                                              
    SKIMMILKA=198.937500*SKIMMILK;                                              
    BACONA=26.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=48.2500000*WHGRBRD;                                                  
    REGDRSNGA=19.2850000*MAYO;                                                  
    PASTAA=210.000000*PASTA;                                                    
    NUTSA=17.1300000*NUTSEED;                                                   
    REGCHIPSA=21.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=1 and age >= 78) then do;                                       
    FRUITA=114.250000*FRUIT;                                                    
    OTHVEGA=67.5209091*OTHVEG;                                                  
    FRTJA=186.750000*FRTJ;                                                      
    OTHPOTA=107.000000*OTHPOT;                                                  
    SALADA=44.6666667*SALAD;                                                    
    DRBEANA=170.100000*DRBEAN;                                                  
    FRFRYA=97.0000000*FRFRY;                                                    
    COLDCERA=33.0000000*COLDCER;                                                
    WHMILKA=203.333333*WHMILK;                                                  
    TWOPMILKA=183.000000*TWOPMILK;                                              
    ONEPMILKA=183.000000*ONEPMILK;                                              
    SKIMMILKA=160.725000*SKIMMILK;                                              
    BACONA=24.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=48.0000000*WHGRBRD;                                                  
    REGDRSNGA=15.6000000*MAYO;                                                  
    PASTAA=210.000000*PASTA;                                                    
    NUTSA=35.9166667*NUTSEED;                                                   
    REGCHIPSA=17.5000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 18 <= age < 28) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=53.7500000*OTHVEG;                                                  
    FRTJA=280.125000*FRTJ;                                                      
    OTHPOTA=122.000000*OTHPOT;                                                  
    SALADA=31.5000000*SALAD;                                                    
    DRBEANA=126.500000*DRBEAN;                                                  
    FRFRYA=79.5000000*FRFRY;                                                    
    COLDCERA=50.0000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=244.000000*ONEPMILK;                                              
    SKIMMILKA=245.000000*SKIMMILK;                                              
    BACONA=26.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=50.0000000*WHGRBRD;                                                  
    REGDRSNGA=17.1400000*MAYO;                                                  
    PASTAA=217.500000*PASTA;                                                    
    NUTSA=18.0000000*NUTSEED;                                                   
    REGCHIPSA=28.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 28 <= age < 38) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=61.6250000*OTHVEG;                                                  
    FRTJA=249.000000*FRTJ;                                                      
    OTHPOTA=127.000000*OTHPOT;                                                  
    SALADA=30.9400000*SALAD;                                                    
    DRBEANA=89.0000000*DRBEAN;                                                  
    FRFRYA=70.0000000*FRFRY;                                                    
    COLDCERA=49.5000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=244.000000*ONEPMILK;                                              
    SKIMMILKA=245.000000*SKIMMILK;                                              
    BACONA=25.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=48.0000000*WHGRBRD;                                                  
    REGDRSNGA=20.6266667*MAYO;                                                  
    PASTAA=217.500000*PASTA;                                                    
    NUTSA=32.0000000*NUTSEED;                                                   
    REGCHIPSA=24.3333333*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 38 <= age < 48) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=61.5000000*OTHVEG;                                                  
    FRTJA=248.800000*FRTJ;                                                      
    OTHPOTA=116.000000*OTHPOT;                                                  
    SALADA=44.2500000*SALAD;                                                    
    DRBEANA=126.500000*DRBEAN;                                                  
    FRFRYA=70.0000000*FRFRY;                                                    
    COLDCERA=44.0000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=183.000000*ONEPMILK;                                              
    SKIMMILKA=244.800000*SKIMMILK;                                              
    BACONA=24.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=47.5000000*WHGRBRD;                                                  
    REGDRSNGA=23.0200000*MAYO;                                                  
    PASTAA=182.525000*PASTA;                                                    
    NUTSA=20.6550000*NUTSEED;                                                   
    REGCHIPSA=27.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 48 <= age < 58) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=61.5325000*OTHVEG;                                                  
    FRTJA=233.250000*FRTJ;                                                      
    OTHPOTA=122.000000*OTHPOT;                                                  
    SALADA=51.8750000*SALAD;                                                    
    DRBEANA=126.500000*DRBEAN;                                                  
    FRFRYA=70.0000000*FRFRY;                                                    
    COLDCERA=43.5000000*COLDCER;                                                
    WHMILKA=244.000000*WHMILK;                                                  
    TWOPMILKA=244.000000*TWOPMILK;                                              
    ONEPMILKA=152.500000*ONEPMILK;                                              
    SKIMMILKA=229.690000*SKIMMILK;                                              
    BACONA=24.0000000*BACON;                                                    
    HOTDOGA=114.000000*HOTDOG;                                                  
    WGBRDA=45.0000000*WHGRBRD;                                                  
    REGDRSNGA=21.8733333*MAYO;                                                  
    PASTAA=185.000000*PASTA;                                                    
    NUTSA=21.2650000*NUTSEED;                                                   
    REGCHIPSA=26.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 58 <= age < 68) then do;                                  
    FRUITA=118.000000*FRUIT;                                                    
    OTHVEGA=63.1650000*OTHVEG;                                                  
    FRTJA=189.755000*FRTJ;                                                      
    OTHPOTA=105.000000*OTHPOT;                                                  
    SALADA=41.2500000*SALAD;                                                    
    DRBEANA=126.500000*DRBEAN;                                                  
    FRFRYA=66.0000000 *FRFRY;                                                   
    COLDCERA=33.0000000*COLDCER;                                                
    WHMILKA=198.250000*WHMILK;                                                  
    TWOPMILKA=183.000000*TWOPMILK;                                              
    ONEPMILKA=183.000000*ONEPMILK;                                              
    SKIMMILKA=196.000000*SKIMMILK;                                              
    BACONA=18.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=45.0000000*WHGRBRD;                                                  
    REGDRSNGA=22.0350000*MAYO;                                                  
    PASTAA=165.000000*PASTA;                                                    
    NUTSA=18.2500000*NUTSEED;                                                   
    REGCHIPSA=20.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and 68 <= age < 78) then do;                                  
    FRUITA=112.427143*FRUIT;                                                    
    OTHVEGA=67.1428571*OTHVEG;                                                  
    FRTJA=186.600000*FRTJ;                                                      
    OTHPOTA=105.000000*OTHPOT;                                                  
    SALADA=33.6666667*SALAD;                                                    
    DRBEANA=126.500000*DRBEAN;                                                  
    FRFRYA=70.0000000*FRFRY;                                                    
    COLDCERA=33.0000000*COLDCER;                                                
    WHMILKA=198.250000*WHMILK;                                                  
    TWOPMILKA=183.000000*TWOPMILK;                                              
    ONEPMILKA=183.000000*ONEPMILK;                                              
    SKIMMILKA=183.750000*SKIMMILK;                                              
    BACONA=19.5000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=42.4000000*WHGRBRD;                                                  
    REGDRSNGA=18.3350000*MAYO;                                                  
    PASTAA=160.000000*PASTA;                                                    
    NUTSA=11.2500000*NUTSEED;                                                   
    REGCHIPSA=18.0000000*CHIPS;                                                 
  end;                                                                          
else if (gender=2 and age >= 78) then do;                                       
    FRUITA=109.000000*FRUIT;                                                    
    OTHVEGA=71.3333333*OTHVEG;                                                  
    FRTJA=186.700000*FRTJ;                                                      
    OTHPOTA=105.000000*OTHPOT;                                                  
    SALADA=41.2500000 *SALAD;                                                   
    DRBEANA=173.000000*DRBEAN;                                                  
    FRFRYA=64.0000000*FRFRY;                                                    
    COLDCERA=33.5000000*COLDCER;                                                
    WHMILKA=196.400000*WHMILK;                                                  
    TWOPMILKA=152.500000*TWOPMILK;                                              
    ONEPMILKA=218.583333*ONEPMILK;                                              
    SKIMMILKA=183.750000*SKIMMILK;                                              
    BACONA=16.0000000*BACON;                                                    
    HOTDOGA=57.0000000*HOTDOG;                                                  
    WGBRDA=34.0000000*WHGRBRD;                                                  
    REGDRSNGA=10.2100000*MAYO;                                                  
    PASTAA=175.000000*PASTA;                                                    
    NUTSA=25.5000000*NUTSEED;                                                   
    REGCHIPSA=14.0000000*CHIPS;                                                 
  end;                                                                          
                                                                                
*create predicted outcomes;                                                     
                                                                                
  if gender=1 then                                                              
   PREDFV7PS = 0.90679 + 0.75856*SQFV7;                                           
  else if gender=2 then                                                         
   PREDFV7PS = 0.81956 + 0.73086*SQFV7;                                           
  LABEL PREDFV7PS='PRED SCR F/V pyr serv - 7 ITEM';                                        
                                                                                
  if gender=1 then                                                              
    PREDFV6PS = 0.94077 + 0.73906*SQFV6;                                          
  else if gender=2 then                                                         
    PREDFV6PS = 0.81626 + 0.73022*SQFV6;                                          
  LABEL PREDFV6PS='PRED SCR F/V pyr serv - 6 ITEM (NO FF)';                                
                                                                                
  if gender=1 then                                                              
    PREDFIB = 2.08423 + (0.00103*FRUITA) + (0.00084*OTHVEGA) +                  
       (0.00019*FRTJA) + (0.00071*OTHPOTA) + (0.00275*DRBEANA) +                
       (0.00160*FRFRYA) + (0.00209*COLDCERA) + (0.00013*WHMILKA) +              
       (0.00013*TWOPMILKA) + (0.00022*ONEPMILKA) + (0.00028*SKIMMILKA) +        
       (-0.00139*BACONA) + (0.00283*WGBRDA) + (0.00075*PASTAA) +                
       (0.00546*NUTSA) + (0.00528*REGCHIPSA) ;                                  
                                                                                
  else if gender=2 then                                                         
   PREDFIB = 1.89847 + (0.00105*FRUITA) + (0.00093*OTHVEGA) +                   
       (0.00025*FRTJA) + (0.00066*OTHPOTA) + (0.00380*DRBEANA) +                
       (0.00156*FRFRYA) + (0.00389*COLDCERA) + (0.00009*WHMILKA) +              
       (0.00011*TWOPMILKA) + (0.00024*ONEPMILKA) + (0.00034*SKIMMILKA) +        
       (-0.00201*BACONA) + (-0.00141*HOTDOGA) + (0.00337*WGBRDA) +              
       (0.00082*PASTAA) + (0.00603*NUTSA) + (0.00456*REGCHIPSA) ;               
  LABEL PREDFIB='PRED SCR FIB (CUBE ROOT) - WITHOUT OTH MILK';                  
                                                                                
  if gender=1 then                                                              
    PREDPCF = 31.93268 + (-0.00932*FRUITA) +                                    
     (-0.00533*FRTJA) + (0.00580*OTHPOTA) + (-0.00526*DRBEANA) +                
     (0.02734*FRFRYA) + (-0.02672*COLDCERA) + (0.00653*WHMILKA) +               
     (0.00215*TWOPMILKA) + (-0.00149*ONEPMILKA) + (-0.00841*SKIMMILKA) +        
     (0.13831*BACONA) + (0.04078*HOTDOGA) + (0.15036*REGDRSNGA) +               
     (-0.00504*PASTAA) + (0.12454*NUTSA) + (0.05376*REGCHIPSA);                 
  else if gender=2 then                                                         
    PREDPCF = 31.36357 + (-0.01201*FRUITA) +                                    
     (-0.01011*FRTJA) + (0.00618*OTHPOTA) + (-0.00608*DRBEANA) +                
     (0.04272*FRFRYA) + (-0.05797*COLDCERA) + (0.00842*WHMILKA) +               
     (0.00272*TWOPMILKA) + (-0.00196*ONEPMILKA) + (-0.00867*SKIMMILKA) +        
     (0.23128*BACONA) + (0.10160*HOTDOGA) + (0.23974*REGDRSNGA) +               
     (-0.00540*PASTAA) + (0.26018*NUTSA) + (0.13144*REGCHIPSA);                 
  LABEL PREDPCF='PRED SCR PERCENT CAL FROM FAT - WITHOUT OTH MILK';     

  label AgeGrp = 'Age group';
  if      18 <= age <= 27 then AgeGrp = 1;
  else if 28 <= age <= 37 then AgeGrp = 2;
  else if 38 <= age <= 47 then AgeGrp = 3;
  else if 48 <= age <= 57 then AgeGrp = 4;
  else if 58 <= age <= 67 then AgeGrp = 5;
  else if 68 <= age <= 77 then AgeGrp = 6;
  else if       age >= 78 then AgeGrp = 7;
run;
 

       
*adjust fruit/veg frequency of food intake by gender/age specific factors;      
* this generates results for cup equivalent MyPyramid units (FVCE FVCENOFF); 

***Input F/V cup equivalent adjustments, from fran.predict.nhis.fortim.cupeq.txt provided by Lisa Kahle 06/15/2007;
data fvcupadj;
  input gender AgeGrp FVCAFruit FVCAFrtJ FVCAFrFry FVCAOthPot FVCASalad FVCAOthVeg FVCADrBean;
  datalines;                                                                                 
1 1 0.999580 1.499160 0.721125 1.000400 0.272700 0.387675 0.717550 
1 2 0.933450 1.250580 0.727700 1.140030 0.353970 0.473920 0.551540 
1 3 0.867300 1.000980 0.641000 0.999600 0.377235 0.499840 0.566720 
1 4 0.867300 1.000980 0.641000 0.999600 0.374963 0.500240 0.612360 
1 5 0.867300 1.000176 0.548055 0.999490 0.416640 0.499905 0.500250 
1 6 0.774916 0.750735 0.480750 0.833175 0.375000 0.460585 0.502285 
1 7 0.657060 0.750735 0.499980 0.754400 0.411323 0.416899 0.575360 
2 1 0.749235 1.124370 0.509595 0.782020 0.306788 0.364468 0.492150 
2 2 0.867300 1.000960 0.455110 0.876945 0.286335 0.395882 0.341550 
2 3 0.844838 1.000176 0.448700 0.771260 0.416625 0.404303 0.430530 
2 4 0.789970 0.938130 0.448700 0.771260 0.499950 0.408330 0.345763 
2 5 0.742350 0.764776 0.394856 0.749700 0.397688 0.416913 0.430685 
2 6 0.712640 0.750728 0.444260 0.771260 0.312469 0.436560 0.430530 
2 7 0.620475 0.750434 0.444260 0.644235 0.374963 0.452214 0.500400 
;
run;


proc sort data=HQX;
  by gender AgeGrp;
run;

***Add the portion size adjustment variables to the HQX dataset and estimate              ;
***cup equivalents of F & V (PREDFV7CE PREDFV6CE).  Adjust the estimates using regression ;
***coefficients from CSFII 94-96.                                                         ;

data HQX;
  merge HQX(in=InHQX) fvcupadj;
  by gender AgeGrp;
  if InHQX;

  ***SAS addition operators are used instead of sum statements so that the;
  ***final values will be missing if any of the food variables are missing;

  RawPREDFV7CE = FRTJ*FVCAFrtJ + FRUIT*FVCAFruit + FRFRY*FVCAFrFry
    + OTHPOT*FVCAOthPot + DRBEAN*FVCADrBean + SALAD*FVCASalad
    + OTHVEG*FVCAOthVeg;

  label PREDFV7CE = 'Daily cup equivalents of fruits & vegetables';
  if      gender = 1 then PREDFV7CE = ( 0.666228 + 0.770652*(sqrt(RawPREDFV7CE)) )**2;
  else if gender = 2 then PREDFV7CE = ( 0.611844 + 0.733890*(sqrt(RawPREDFV7CE)) )**2;
  

  RawPREDFV6CE = FRTJ*FVCAFrtJ + FRUIT*FVCAFruit
    + OTHPOT*FVCAOthPot + DRBEAN*FVCADrBean + SALAD*FVCASalad
    + OTHVEG*FVCAOthVeg;

  label PREDFV6CE = 'Daily cup equivalents of fruits & vegetables except French fries';
  if      gender = 1 then PREDFV6CE = ( 0.706696 + 0.742255*(sqrt(RawPREDFV6CE)) )**2;
  else if gender = 2 then PREDFV6CE = ( 0.616033 + 0.727761*(sqrt(RawPREDFV6CE)) )**2;



